#pragma once

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/http/include/url.h>
#include <maps/wikimap/mapspro/services/mrc/libs/proto/include/named_sizes.h>
#include <maps/libs/geolib/include/heading.h>
#include <yandex/maps/proto/common2/geo_photo.pb.h>
#include <yandex/maps/proto/common2/geometry.pb.h>
#include <yandex/maps/proto/common2/i18n.pb.h>

namespace maps::mrc::proto {

auto makeTime(chrono::TimePoint, const std::locale&)
    -> yandex::maps::proto::common2::i18n::Time;

auto makeDuration(std::chrono::seconds, const std::locale&)
    -> yandex::maps::proto::common2::i18n::LocalizedValue;

template <class... Ts>
auto makeDuration(std::chrono::duration<Ts...> duration,
                  const std::locale& locale)
    -> yandex::maps::proto::common2::i18n::LocalizedValue
{
    return makeDuration(
        std::chrono::duration_cast<std::chrono::seconds>(duration), locale);
}

auto makeDistance(unsigned meters, const std::locale&)
    -> yandex::maps::proto::common2::i18n::LocalizedValue;

auto makeDirection(geolib3::Heading)
    -> yandex::maps::proto::common2::geometry::Direction;

auto makeImage(const http::URL&, std::string_view sizeParam, const TNamedSizes&)
    -> yandex::maps::proto::common2::Image;

}  // namespace maps::mrc::proto
