#include <library/cpp/testing/gtest/gtest.h>
#include <maps/wikimap/mapspro/services/mrc/libs/proto/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/proto/include/named_sizes.h>

namespace maps::mrc::proto::tests {

TEST(named_sizes, prepare_named_sizes)
{
    auto size = common::Size{1920, 1080};
    auto feature =
        sql_chemistry::GatewayAccess<db::Feature>::construct().setSize(size);
    auto result = prepareNamedSizes(feature);
    auto expected =
        TNamedSizes{{SIZE_NAME_ORIGINAL, size},
                    {SIZE_NAME_THUMBNAIL, common::getThumbnailSize(size)}};
    EXPECT_EQ(result, expected);
}

TEST(common, make_image)
{
    auto namedSizes = TNamedSizes{{SIZE_NAME_ORIGINAL, {1920, 1080}},
                                  {SIZE_NAME_THUMBNAIL, {240, 135}}};
    auto url = http::URL{"http://localhost"}
                   .setPath("/v1/rides/my/photo_image")
                   .addParam("photo_id", "123");
    auto proto = makeImage(url, "size_name", namedSizes);
    auto str = TString{};
    auto out = TStringOutput{str};
    proto.PrintJSON(out);
    auto expected =
        R"({"url_template":"http://localhost/v1/rides/my/photo_image?photo_id=123&size_name=%s","size":[{"size":"original","width":1920,"height":1080},{"size":"thumbnail","width":240,"height":135}]})";
    EXPECT_EQ(json::Value(str), json::Value(expected));
}

}  // namespace maps::mrc::proto::tests
