#pragma once
#include <maps/wikimap/mapspro/libs/tf_inferencer/tf_inferencer.h>
#include <maps/wikimap/mapspro/services/mrc/libs/traffic_signs/include/yandex/maps/mrc/traffic_signs/signs.h>

#include <opencv2/opencv.hpp>

namespace maps {

namespace wiki {
namespace tf_inferencer {

class FasterRCNNInferencer;

} // namespace tf_inferencer
} // namespace wiki

namespace mrc {
namespace roadmarkdetector {

struct RoadMarkDetection{
    cv::Rect box;
    maps::mrc::traffic_signs::TrafficSign type;
    float confidence;
};

typedef std::vector<RoadMarkDetection> RoadMarkDetectionVector;

class RoadMarkDetector {
public:
    RoadMarkDetector();
    ~RoadMarkDetector();

    /**
     * @brief Detect and classify road marking on the bird view image
     * @param image     input color bird view image
     * @return result   vector of detected marks on the road
     */
    RoadMarkDetectionVector detect(const cv::Mat &image) const;
private:
    void evalSupportedTypes();

    std::vector<maps::mrc::traffic_signs::TrafficSign> supportedTypes_;

    std::unique_ptr<wiki::tf_inferencer::FasterRCNNInferencer> tfInferencerFasterRCNN_;
};


} // roadmarkdetector
} // mrc
} // maps
