#pragma once

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/geolib/include/heading.h>

#include <string>

namespace maps{
namespace mrc {
namespace self_driving {

struct Quaternion {
    double x;
    double y;
    double z;
    double w;
};

struct CarPosition {
    double lat;
    double lon;
    double speed; // m/s
    Quaternion orientation;
    chrono::TimePoint time;

    geolib3::Heading heading() const;
};

std::vector<CarPosition> loadSelfDrivingTrack(const std::string& filename);

} // namespace self_driving
} // namespace mrc
} // namespace maps
