#include <library/cpp/testing/gtest/gtest.h>
#include <library/cpp/testing/common/env.h>
#include <maps/wikimap/mapspro/services/mrc/libs/self_driving_car/include/car_position.h>

#include <cmath>

namespace maps {
namespace mrc {
namespace self_driving {
namespace tests {
namespace {

const std::string DATASET_PATH = ArcadiaSourceRoot()
    + "/maps/wikimap/mapspro/services/mrc/libs/self_driving_car/tests/dataset.txt";

}

TEST(self_driving_dataset_tests, test_load)
{
    auto track = loadSelfDrivingTrack(DATASET_PATH);
    EXPECT_EQ(track.size(), 2u);

    EXPECT_EQ(track[0].lat, 2);
    EXPECT_EQ(track[0].lon, 4);
    EXPECT_EQ(track[0].speed, 8);
    EXPECT_NEAR(track[0].heading().value(), 60, 0.001);
    EXPECT_EQ(track[0].time, chrono::TimePoint(
                  std::chrono::milliseconds(15345678960123)));

    EXPECT_EQ(track[1].lat, 0.5);
    EXPECT_EQ(track[1].lon, 0.25);
    EXPECT_EQ(track[1].speed, 0.125);
    EXPECT_NEAR(track[1].heading().value(), -60, 0.001);
    EXPECT_EQ(track[1].time, chrono::TimePoint(
                  std::chrono::milliseconds(1533333333555)));
}

} // namespace tests
} // namespace self_driving
} // namespace mrc
} // namespace maps
