#pragma once

#include "types.h"
#include "object_ray.h"

namespace maps::mrc::sensors_feature_positioner {

// calculates objects positions and returns aggregated object groups
ResultObjects calculateObjectsPositionsFromOneRide(Rays rays);

// Splits rays from different sources into separate rides
// Calculates objects positions for each ride and returns aggregated object groups
// Doesn't merge objects between rides
ResultObjects calculateObjectsPositions(const Rays& rays);

std::vector<Rays> separateBySourceIdAndSort(Rays rays);

geolib3::Heading calculateObjectHeading(const ResultObject& resultObject);

} // namespace maps::mrc::sensors_feature_positioner
