#pragma once

#include "types.h"

namespace maps::mrc::sensors_feature_positioner {

constexpr double IMAGE_X_FOV = 70.0 * M_PI / 180.0;

Ray constructRay(
    common::ImageBox bbox,
    pos_improvment::ImprovedGpsEvent cameraPosition,
    common::Size photoSize,
    size_t rayId,
    db::TId featureId,
    const std::string& sourceId,
    double objectMaxSideLengthMeters,
    size_t typeId = 0);

} // namespace maps::mrc::sensors_feature_positioner
