#pragma once

#include "types.h"

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>
#include <maps/wikimap/mapspro/services/mrc/libs/graph_matcher_adapter/include/compact_graph_matcher_adapter.h>

#include <string>

namespace maps::mrc::sensors_feature_positioner {

// Tool for calculating position using sensors. Works only
// with one solid track without gaps.
class SensorsFeaturePositioner {
public:
    SensorsFeaturePositioner(
        const adapters::Matcher& graphMatcher,
        const db::TrackPoints& trackPoints,
        const SensorEvents& sensorEvents);

    // returns the position if the timepoint belongs to the track of the positioner
    std::optional<pos_improvment::ImprovedGpsEvent> getPositionByTime(
        chrono::TimePoint time) const;

    chrono::TimePoint trackStartTime() const { return improvedGpsTrack_.front().timestamp(); };
    chrono::TimePoint trackEndTime() const { return improvedGpsTrack_.back().timestamp(); };

private:
    pos_improvment::ImprovedGpsEvents improvedGpsTrack_;
};

using SensorsFeaturePositioners = std::vector<SensorsFeaturePositioner>;

} // namespace maps::mrc::sensors_feature_positioner
