#pragma once

#include "types.h"

#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ride_recording_report_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ugc/assignment_recording_report_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/position_improvment/include/position_improvment.h>

#include <string>

namespace maps::mrc::sensors_feature_positioner {

SensorEvents loadAssignmentSensors(
    mds::Mds& mdsClient,
    pgpool3::Pool& pool,
    chrono::TimePoint minTime,
    chrono::TimePoint maxTime,
    std::string sourceId,
    db::TId assignmentId);

SensorEvents loadRideSensors(
    mds::Mds& mdsClient,
    pgpool3::Pool& pool,
    chrono::TimePoint minTime,
    chrono::TimePoint maxTime,
    std::string sourceId);

// Loads sensors from stringstreams(such string streams reports are stored in mds)
SensorEvents extractSensors(std::vector<std::stringstream>& reports,
                            std::optional<chrono::TimePoint> minTime,
                            std::optional<chrono::TimePoint> maxTime);

} // namespace maps::mrc::sensors_feature_positioner

