#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/sign.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/track_point_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/position_improvment/include/position_improvment.h>

namespace maps::mrc::sensors_feature_positioner {

struct SensorEvents {
    pos_improvment::GyroscopeEvents gyroEvents;
    pos_improvment::AccelerometerEvents accEvents;
};

struct Track {
    db::TrackPoints trackPoints;
    SensorEvents sensorEvents;
};
using Tracks = std::vector<Track>;

using RayId = size_t;

struct Ray {
    size_t objectTypeId;
    pos_improvment::ImprovedGpsEvent cameraPos;
    pos_improvment::UnitVector3 directionToObject;
    double metersToObject;
    RayId rayId;
    db::TId featureId;
    std::string sourceId;
};
using Rays = std::vector<Ray>;

using IntersectionId = size_t;

struct ObjectIntersection {
    IntersectionId id;
    geolib3::Point3 odoMercatorPos;
    double errorMeters;
    geolib3::Radians errorRadians; // max angle between the camera
                                   // direction and the vector from
                                   // the camera to the object position
    Ray ray1;
    Ray ray2;
    double metersFromCamera1;
    double metersFromCamera2;


    geolib3::Point2 mercatorPos() const {
        geolib3::Point2 odoMercPos(odoMercatorPos.x(),
                                   odoMercatorPos.y());
        return ray2.cameraPos.mercatorPosition()
            + (odoMercPos - ray2.cameraPos.odometerMercatorPosition());
    }

    double heightMeters() const {
        return geolib3::toMeters(
            odoMercatorPos.z(),
            ray2.cameraPos.mercatorPosition());
    }
};
using ObjectIntersections = std::vector<ObjectIntersection>;

struct RayIntersections {
    size_t rayId;
    std::vector<ObjectIntersection> intersections;
};

struct ResultObject {
    geolib3::Point2 mercatorPos;
    Rays rays;
};

using ResultObjects = std::vector<ResultObject>;

} // namespace maps::mrc::sensors_feature_positioner
