#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/sensors_feature_positioner/include/types.h>

namespace maps::mrc::sensors_feature_positioner {

// the Gps+sensors algorithm calculates the azimuth difference between
// the car and the camera orientation once for the entire solid
// track. But for short tracks the error can be about 10 degrees. And
// drivers can slightly rotate cameras during the ride.
// If camera azimuth has a constant shift, the 3d rays from the camera to
// objects don't intersect.
// We can fix this shift:
// For each part of the track we try to rotate the camera azimuth on
// the entire part using some shift. We try several values of possible
// shifts and select the shift with the best rays intersections.
Rays calibrateRaysAzimuth(Rays rays);

} // namespace maps::mrc::sensors_feature_positioner
