#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/sensors_feature_positioner/include/types.h>
#include "utils.h"

namespace maps::mrc::sensors_feature_positioner {

const double MAX_METERS_BETWEEN_CAMERAS = 50;
const double MIN_METERS_BETWEEN_CAMERAS = 1;

const geolib3::Radians MAX_ANGLE_BETWEEN_CAMERAS(80 * M_PI / 180.0);
const geolib3::Radians MIN_ANGLE_BETWEEN_CAMERAS(4.0 * M_PI / 180.0);

std::optional<ObjectIntersection> createObjectFrom2Photos(const Ray& ray1,
                                                          const Ray& ray2,
                                                          IdGenerator& idGenerator);

} // namespace maps::mrc::sensors_feature_positioner
