#pragma once
#include <maps/wikimap/mapspro/services/mrc/libs/sensors_feature_positioner/include/types.h>

namespace maps::mrc::sensors_feature_positioner {

struct ObjectPosition {
    geolib3::Point3 mercatorPos;
    Ray ray;

    geolib3::Point2 mercatorPos2d() const {
        return geolib3::Point2(mercatorPos.x(), mercatorPos.y());
    }

};
using ObjectPositions = std::vector<ObjectPosition>;

// 1) calculate object position for each ray
// 2) group similar neighboring objects (only in each small part of the sequence)
// 3) return groups
// Don't group objects from different part of the sequence(car track)
// Returns object positions(several possible positions for each object)
std::vector<ObjectPositions> calculateObjects(Rays& rays);

} // namespace maps::mrc::sensors_feature_positioner
