#include "utils.h"

#include <maps/libs/geolib/include/distance.h>

namespace maps::mrc::sensors_feature_positioner {

double metersBetweenCameras(const Ray& ray1, const Ray& ray2)
{
    return geolib3::toMeters(
        distance(
            ray1.cameraPos.odometerMercatorPosition(),
            ray2.cameraPos.odometerMercatorPosition()),
        ray1.cameraPos.mercatorPosition());
}

} // namespace maps::mrc::sensors_feature_positioner
