#include "utils.h"

namespace maps::mrc::sensors_feature_positioner::tests {

using namespace maps::mrc::pos_improvment;

using maps::geolib3::Vector3;

Ray createRay(traffic_signs::TrafficSign signType,
              geolib3::Point2 cameraMercPos,
              geolib3::Point2 cameraOdoMercPos,
              pos_improvment::UnitVector3 directionToObject,
              double metersToObject,
              RayId rayId,
              db::TId featureId,
              const std::string& sourceId,
              pos_improvment::Time timestamp)
{
    // all these constants should not be used in object position algorithms

    const geolib3::Radians carDirection(M_PI); // to West
    const GpsEvent gpsEvent(timestamp, cameraMercPos, 0.0_m, 10.0_mps, carDirection);

    UnitVector3 cameraFrontDirection(Vector3(0, 1, 0)); // to North
    UnitVector3 cameraRightDirection(Vector3(1, 0, 0)); // to East
    UnitVector3 cameraUpDirection(Vector3(0, 0, 1)); // to sky
    ImprovedGpsEvent cameraPosition(gpsEvent,
                                    cameraOdoMercPos,
                                    cameraFrontDirection,
                                    cameraRightDirection,
                                    cameraUpDirection);

    return Ray{static_cast<size_t>(signType), cameraPosition, directionToObject,
            metersToObject, rayId, featureId, sourceId};
}

} // namespace maps::mrc::sensors_feature_positioner::tests
