#pragma once
#include <maps/wikimap/mapspro/libs/tf_inferencer/maskrcnn_inferencer.h>

#include <opencv2/opencv.hpp>

namespace maps {
namespace mrc {
namespace sideview {

enum class SideViewType {
    ForwardView,
    SideView,
};

class SideViewClassifier {
public:
    SideViewClassifier();

    /**
     * @brief Determine camera view (forward or side) by pair of consecutive photo
     * @param image1, image2   input color images
     * @return result          (class name, confidence)
     */
    std::pair<SideViewType, float> inference(const cv::Mat &image1, const cv::Mat &image2) const;
private:
    maps::wiki::tf_inferencer::TensorFlowInferencer inferencer;
    std::vector<std::string> classesNames;

    void evalClassesNames();
};


} // sideview
} // mrc
} // maps
