#include <maps/wikimap/mapspro/services/mrc/libs/sideview_classifier/include/sideview.h>

#include <library/cpp/testing/gtest/gtest.h>
#include <library/cpp/testing/common/env.h>
#include <maps/libs/common/include/exception.h>
#include <maps/libs/common/include/file_utils.h>

#include <opencv2/opencv.hpp>

#include <fstream>
#include <iostream>
#include <sstream>
#include <unordered_set>
#include <utility>
#include <vector>

using namespace testing;

namespace maps {
namespace mrc {
namespace sideview {

namespace tests {

namespace {

using TestData = std::tuple<std::string, std::string, SideViewType>;

const std::vector<TestData> REFERENCE_IMAGES =
{
    {"forward_view1.jpg", "forward_view2.jpg", SideViewType::ForwardView},
    {"side_view1.jpg",    "side_view2.jpg",    SideViewType::SideView},
};

cv::Mat loadImage(const std::string& name, int flags) {
    static const std::string IMAGES_DIR =
        "maps/wikimap/mapspro/services/mrc/libs/sideview_classifier/tests/images/";
    auto imagePath = static_cast<std::string>(BinaryPath(IMAGES_DIR + name));
    cv::Mat image = cv::imread(imagePath, flags);
    REQUIRE(image.data != nullptr, "Can't load image " << name);
    return image;
}

} // namespace

TEST(basic_tests, segm_sideview_on_reference_images)
{
    SideViewClassifier classifier;
    std::pair<SideViewType, float> result;
    for (size_t i = 0; i < REFERENCE_IMAGES.size(); i++){
        cv::Mat image1 = loadImage(std::get<0>(REFERENCE_IMAGES[i]), cv::IMREAD_COLOR);
        cv::Mat image2 = loadImage(std::get<1>(REFERENCE_IMAGES[i]), cv::IMREAD_COLOR);
        result = classifier.inference(image1, image2);
        EXPECT_THAT(result.first, Eq(std::get<2>(REFERENCE_IMAGES[i])))
            << " invalid view classified for images: " << std::get<0>(REFERENCE_IMAGES[i]) << " and " << std::get<1>(REFERENCE_IMAGES[i]);
    }
}

} // namespace test

} // namespace sideview
} // namespace mrc
} // namespace maps
