#pragma once

#include <maps/libs/common/include/pimpl_utils.h>

#include <boost/optional.hpp>

#include <string>

namespace maps {
namespace mrc {
namespace signal_queue {

/**
 * Process-safe local persistent storage for user-generated results
 * Uses SQLine internally.
 */
class ResultsQueue
{
public:
    /**
     * Expects folder to be passed as basePath.
     * Results will be stored in independent files (one per result type)
     * inside the given folder
     */
    explicit ResultsQueue(const std::string& basePath);

    template<typename Result>
    void push(const Result& result);

    template<typename Result>
    boost::optional<Result> pop();

    template<typename Result>
    size_t count();

private:
    NONCOPYABLE_PIMPL_DECLARATIONS(ResultsQueue);
};

} // signal_queue
} // mrc
} // maps
