#include <yandex/maps/mrc/signal_queue/result_queue.h>
#include "traits.h"

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/persistent_queue.h>
#include <maps/libs/common/include/exception.h>

#include <boost/lexical_cast.hpp>

namespace maps {
namespace mrc {
namespace signal_queue {

namespace {

template<typename T>
std::string makeSqlitePath(const std::string& basePath)
{
    return (basePath + "/" + ResultTraits<T>::SQLITE_FILENAME);
}

} //anonymous namespace

class ResultsQueue::Impl
{
public:
    Impl(const std::string& basePath)
        : imagesQueue(makeSqlitePath<AssignmentImage>(basePath))
        , rideImagesQueue(makeSqlitePath<RideImage>(basePath))
    {
    }

    common::PersistentQueue imagesQueue;
    common::PersistentQueue rideImagesQueue;
};

common::PersistentQueue& ResultTraits<AssignmentImage>::getQueue(ResultsQueue& q)
{
    return PImplFactory::impl(q).imagesQueue;
}

common::PersistentQueue& ResultTraits<RideImage>::getQueue(ResultsQueue& q)
{
    return PImplFactory::impl(q).rideImagesQueue;
}

ResultsQueue::ResultsQueue(const std::string& basePath)
    : impl_(new Impl(basePath))
{
}

template<typename T>
void ResultsQueue::push(const T& result)
{
    auto serialized = boost::lexical_cast<std::string>(result);
    ResultTraits<T>::getQueue(*this).push(serialized);
}

template<typename Result>
boost::optional<Result> ResultsQueue::pop()
{
    auto serialized = ResultTraits<Result>::getQueue(*this).pop();
    if (serialized) {
        return boost::lexical_cast<Result>(serialized.get());
    } else {
        return boost::none;
    }
}

template<typename Result>
size_t ResultsQueue::count()
{
    return ResultTraits<Result>::getQueue(*this).size();
}

template void ResultsQueue::push<AssignmentImage>(const AssignmentImage&);
template void ResultsQueue::push<RideImage>(const RideImage&);
template boost::optional<AssignmentImage> ResultsQueue::pop<AssignmentImage>();
template boost::optional<RideImage> ResultsQueue::pop<RideImage>();
template size_t ResultsQueue::count<AssignmentImage>();
template size_t ResultsQueue::count<RideImage>();

NONCOPYABLE_PIMPL_DEFINITIONS(ResultsQueue);

} //namespace signal_queue
} //namespace mrc
} //namespace maps
