#pragma once

#include <yandex/maps/mrc/traffic_signs/signs.h>

#include <opencv2/opencv.hpp>

#include <string>
#include <vector>
#include <iostream>

namespace maps {
namespace mrc {
namespace signdetect {


struct DetectedSign {
    cv::Rect box;
    traffic_signs::TrafficSign sign;
    float confidence = 0.;
    traffic_signs::TemporarySign temporarySign = traffic_signs::TemporarySign::No;
    float temporarySignConfidence = 0.;
    std::string number = "";
    float numberConfidence = 0.;
};

std::ostream& operator<<(std::ostream& os, const DetectedSign& sign);

using DetectedSigns = std::vector<DetectedSign>;


} // signdetect
} // namespace mrc
} // namespace maps
