#pragma once

#include "maps/wikimap/mapspro/services/mrc/libs/signdetect/include/detected_sign.h"
#include "maps/wikimap/mapspro/services/mrc/libs/signdetect/include/signdetect_faster_rcnn.h"

#include <opencv2/opencv.hpp>

#include <memory>
#include <vector>

namespace maps::mrc::signdetect {

class SignDetectorComplex {
public:
    SignDetectorComplex();
    ~SignDetectorComplex();

    DetectedSigns detect(const cv::Mat& image) const;

    const std::vector<traffic_signs::TrafficSign>& supportedSigns() const;
private:
    FasterRCNNDetector fasterRCNNDetector_;

    void evalSupportedSigns();
    std::vector<traffic_signs::TrafficSign> supportedSigns_;
};

} // namespace maps::mrc::signdetect
