#pragma once

#include "detected_sign.h"
#include "maps/wikimap/mapspro/services/mrc/libs/number_recognizer/include/number_recognizer.h"

#include <opencv2/opencv.hpp>

#include <memory>
#include <vector>

namespace maps {

namespace wiki {
namespace tf_inferencer {

class TensorFlowInferencer;
class FasterRCNNInferencer;

} // namespace tf_inferencer
} // namespace wiki

namespace mrc {
namespace signdetect {

class FasterRCNNDetector {
public:
    FasterRCNNDetector();
    ~FasterRCNNDetector();

    DetectedSigns detect(const cv::Mat& image) const;

    const std::vector<traffic_signs::TrafficSign>& supportedSigns() const;
private:
    void evalSupportedSigns();

    /*
     * return propability is this sign temprorary or not
    */
    float calcTemporarySignConfidence(const cv::Mat &sign) const;

    std::unique_ptr<wiki::tf_inferencer::TensorFlowInferencer> tfInferencer_;
    std::unique_ptr<wiki::tf_inferencer::FasterRCNNInferencer> tfInferencerFasterRCNN_;
    std::vector<traffic_signs::TrafficSign> supportedSigns_;
    number_recognizer::NumberRecognizer numberRecognizer_;

    long temporarySignIdx_;
    void evalTemporarySignIdx();
};

} // signdetect
} // namespace mrc
} // namespace maps
