OWNER(quoter vbystricky)

LIBRARY()

ADDINCL (
   GLOBAL contrib/libs/opencv/include
)

PEERDIR (
    contrib/libs/opencv
    maps/libs/common
    maps/libs/json
    maps/wikimap/mapspro/libs/tf_inferencer
    maps/wikimap/mapspro/services/mrc/libs/common
    maps/wikimap/mapspro/services/mrc/libs/number_recognizer
    maps/wikimap/mapspro/services/mrc/libs/traffic_signs
)

SRCS(
    impl/detected_sign.cpp
    impl/sign_relations.cpp
    impl/signdetect_complex.cpp
    impl/signdetect_faster_rcnn.cpp
)

FROM_SANDBOX(
    3183509565
    OUT_NOAUTO
    tf_model.gdef
    tf_model_faster_rcnn.gdef
    tf_model_number_recognizer.gdef
)

RESOURCE (
    tf_model.gdef /maps/mrc/signdetect/models/tf_model.gdef
    tf_model_faster_rcnn.gdef /maps/mrc/signdetect/models/tf_model_faster_rcnn.gdef
    tf_model_number_recognizer.gdef /maps/mrc/signdetect/models/tf_model_number_recognizer.gdef
)

END()

RECURSE(
    tests
)
