#include <library/cpp/testing/common/env.h>
#include <library/cpp/testing/gtest/gtest.h>
#include <maps/wikimap/mapspro/services/mrc/libs/common/include/keypoints.h>
#include <maps/wikimap/mapspro/services/mrc/libs/superpoint/include/superpoint.h>

#include <string>

namespace maps::mrc::superpoint::tests {

namespace {

cv::Mat load(const std::string& name, int flags) {
    const std::string peffix = "maps/wikimap/mapspro/services/mrc/libs/superpoint/tests/images/";
    const std::string path(BinaryPath(peffix + name));
    return cv::imread(path, flags);
}

}

TEST(superpoints, basic)
{
    SuperpointDetector sptDetector;

    sptDetector.detect(load("1.jpg", cv::IMREAD_COLOR));
    sptDetector.detect(load("2.jpg", cv::IMREAD_GRAYSCALE));
    sptDetector.detect(load("3.jpg", cv::IMREAD_COLOR));
}

TEST(superpoints, batch)
{
    SuperpointDetector sptDetector;

    maps::wiki::tf_inferencer::ImagesBatch batch;
    batch.emplace_back(load("1.jpg", cv::IMREAD_COLOR));
    batch.emplace_back(load("2.jpg", cv::IMREAD_COLOR));
    batch.emplace_back(load("3.jpg", cv::IMREAD_COLOR));

    std::vector<common::Keypoints> results = sptDetector.detect(batch);
    EXPECT_EQ(results.size(), 3u);
}

} // namespace maps::mrc::tests
