#include "assignment_impl.h"
#include "task_suite_impl.h"
#include "magic_strings.h"

namespace maps {
namespace mrc {
namespace toloka {
namespace io {

/**
 * https://tech.yandex.ru/toloka/api/doc/concepts/result-docpage/
 */
Assignment::Impl::Impl(const json::Value& value)
    : id_(value[FIELD_ID].as<std::string>())
    , poolId_(value[FIELD_POOL_ID].as<std::string>())
    , status_(boost::lexical_cast<AssignmentStatus>(value[FIELD_STATUS].as<std::string>()))
    , taskSuiteId_(value[FIELD_TASK_SUITE_ID].as<std::string>())
    , userId_(value[FIELD_USER_ID].as<std::string>())
    , createdAt_(chrono::parseIsoDateTime(value[FIELD_CREATED].as<std::string>()))
{
    if (value.hasField(FIELD_SUBMITTED)) {
        submittedAt_ = chrono::parseIsoDateTime(
                value[FIELD_SUBMITTED].as<std::string>());
    }

    if (value.hasField(FIELD_ACCEPTED)) {
        acceptedAt_ = chrono::parseIsoDateTime(
                value[FIELD_ACCEPTED].as<std::string>());
    }

    for (const auto& jsonTask : value[FIELD_TASKS]) {
        tasks_.push_back(TaskSuiteItem::fromJson(jsonTask));
    }

    if (value.hasField(FIELD_SOLUTIONS)) {
        for (const auto& solution : value[FIELD_SOLUTIONS]) {
            solutions_.push_back(PImplFactory::create<AssignmentSolution>(
                solution[FIELD_OUTPUT_VALUES])
            );
        }
    }
}

} // namespace io
} // namespace toloka
} // namespace mrc
} // namespace maps

