#pragma once

#include <yandex/maps/mrc/toloka_client/assignment.h>

namespace maps {
namespace mrc {
namespace toloka {
namespace io {

class AssignmentSolution::Impl
{
public:
    explicit Impl(json::Value outputValues)
        : outputValues_(std::move(outputValues))
    {
    }

    json::Value outputValues_;
};

class Assignment::Impl
{
public:
    // Parse Toloka server response
    explicit Impl(const json::Value& value);

    std::string id_;
    std::string poolId_;
    AssignmentStatus status_;
    std::string taskSuiteId_;
    std::string userId_;
    chrono::TimePoint createdAt_;
    boost::optional<chrono::TimePoint> submittedAt_;
    boost::optional<chrono::TimePoint> acceptedAt_;
    TaskSuiteItems tasks_;
    AssignmentSolutions solutions_;
};


class AssignmentsResponse::Impl
{
public:
    Impl(Assignments assignments, bool hasMore)
        : assignments_(std::move(assignments)), hasMore_(hasMore)
    {
    }

    Assignments assignments_;
    bool hasMore_;
};

} // namespace io
} // namespace toloka
} // namespace mrc
} // namespace maps
