#include "client_impl.h"

namespace maps {
namespace mrc {
namespace toloka {
namespace io {

std::unique_ptr<http::Client> TolokaClient::Impl::makeHttpClient() const
{
    std::unique_ptr<http::Client> httpClient(new http::Client);
    if (timeout_ > cr::milliseconds::zero()) {
        httpClient->setTimeout(timeout_);
    }
    return httpClient;
}

void TolokaClient::Impl::addAuthHeader(http::Request& request) const
{
    request.addHeader("Authorization", authHeader_);
}

void TolokaClient::Impl::addContentTypeHeader(http::Request& request) const
{
    request.addHeader("Content-Type", "application/json");
}

http::Response TolokaClient::Impl::performRequestChecked(
        http::Request& request,
        const http::URL& url) const
{
    auto response = [&](){
        try {
            return request.perform();
        } catch (maps::http::Error& e) {
            throw ServerError() << "http request failed: " << e.what()
                                << ", url: " << url;
        }
    }();

    if (response.status() >= 500) {
        throw ServerError() << "Unexpected status: " << response.status()
                            << ", url: " << url;
    } else if (response.status() / 100 != 2) {
        throw ClientError() << "Unexpected status: " << response.status()
                            << ", url: " << url;
    }
    return response;
}


} // namespace io
} // namespace toloka
} // namespace mrc
} // namespace maps
