#include "client_impl.h"

namespace maps {
namespace mrc {
namespace toloka {
namespace io {

std::string TolokaClient::Impl::getAttachment(const std::string& attachmentId) const
{
    auto httpClient = makeHttpClient();
    http::URL url = schema_ + host_ + "/api/v1/attachments/" + attachmentId + "/download";

    auto response = retry([&](){
        http::Request request(*httpClient, http::GET, url);
        addAuthHeader(request);

        return performRequestChecked(request, url);
    });

    return response.readBody();
}

} // namespace io
} // namespace toloka
} // namespace mrc
} // namespace maps
