#include "client_impl.h"
#include "magic_strings.h"
#include "requester_impl.h"
#include <yandex/maps/mrc/toloka_client/requester.h>
#include <maps/libs/json/include/exception.h>

namespace maps {
namespace mrc {
namespace toloka {
namespace io {

Requester TolokaClient::Impl::getRequester() const
{
    auto httpClient = makeHttpClient();
    http::URL url = schema_ + host_ + "/api/v1/requester";

    auto response = retry([&](){
        http::Request request(*httpClient, http::GET, url);
        addAuthHeader(request);

        return performRequestChecked(request, url);
    });

    try {
        auto jsonBody = json::Value::fromStream(response.body());
        return PImplFactory::create<Requester>(jsonBody);
    } catch (const maps::json::ParserError& e) {
        throw ServerError() << "Failed to parse server response, url: " << url
                << ": " << e.what();
    }
}

} // namespace io
} // namespace toloka
} // namespace mrc
} // namespace maps
