#pragma once

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/common/include/pimpl_utils.h>
#include <maps/libs/json/include/value.h>
#include <yandex/maps/mrc/toloka_client/task_suite.h>

#include <boost/optional.hpp>

#include <string>
#include <vector>

namespace maps {
namespace mrc {
namespace toloka {
namespace io {

enum class AssignmentStatus
{
    Active,
    Submitted,
    Accepted,
    Rejected,
    Skipped,
    Expired
};

std::ostream& operator<<(std::ostream& os, AssignmentStatus status);
std::istream& operator>>(std::istream& is, AssignmentStatus& status);


class AssignmentSolution
{
public:
    const json::Value& outputValues() const;

    COPYABLE_PIMPL_DECLARATIONS(AssignmentSolution)
};

using AssignmentSolutions = std::vector<AssignmentSolution>;

/**
 * Task or task suite assignment accomplished by a single user.
 */
class Assignment
{
public:
    const std::string& id() const;

    const std::string& poolId() const;

    AssignmentStatus status() const;

    const std::string& taskSuiteId() const;

    const std::string& userId() const;

    chrono::TimePoint createdAt() const;

    const boost::optional<chrono::TimePoint>& submittedAt() const;

    const boost::optional<chrono::TimePoint>& acceptedAt() const;

    const TaskSuiteItems& tasks() const;

    const AssignmentSolutions& solutions() const;

    MOVABLE_PIMPL_DECLARATIONS(Assignment)
};


using Assignments = std::vector<Assignment>;

class AssignmentsResponse
{
public:
    const Assignments& assignments() const;

    bool hasMore() const;

    MOVABLE_PIMPL_DECLARATIONS(AssignmentsResponse)
};

} // namespace io
} // namespace toloka
} // namespace mrc
} // namespace maps
