#pragma once

#include <yandex/maps/mrc/toloka_client/assignment.h>
#include <yandex/maps/mrc/toloka_client/pool.h>

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/common/include/pimpl_utils.h>
#include <maps/libs/http/include/http.h>

#include <string>

namespace maps {
namespace mrc {
namespace toloka {
namespace io {

class Filter
{
public:
    Filter();

    Filter& byProjectId(const std::string& projectId);

    Filter& byPoolId(const std::string& poolId);

    Filter& byPoolStatus(PoolStatus poolStatus);

    Filter& byTaskId(const std::string& taskId);

    Filter& byTaskSuiteId(const std::string& taskSuiteId);

    Filter& byAssignmentStatus(AssignmentStatus assignmentStatus);

    Filter& byUserId(const std::string& userId);

    Filter& idGreaterThan(const std::string& id);
    Filter& idLessThan(const std::string& id);

    Filter& createdAfter(chrono::TimePoint timePoint);
    Filter& createdBefore(chrono::TimePoint timePoint);
    Filter& createdNotEarlierThan(chrono::TimePoint timePoint);
    Filter& createdNotLaterThan(chrono::TimePoint timePoint);

    Filter& submittedAfter(chrono::TimePoint timePoint);
    Filter& submittedBefore(chrono::TimePoint timePoint);
    Filter& submittedNotEarlierThan(chrono::TimePoint timePoint);
    Filter& submittedNotLaterThan(chrono::TimePoint timePoint);

    template <typename T>
    void apply(http::Request& request) const;

    COPYABLE_PIMPL_DECLARATIONS(Filter)
};

} // namespace io
} // namespace toloka
} // namespace mrc
} // namespace maps
