#pragma once

#include <maps/libs/common/include/pimpl_utils.h>

#include <string>

namespace maps {
namespace mrc {
namespace toloka {
namespace io {

class RequesterName {
public:
    const std::string& RU() const;
    const std::string& EN() const;

    MOVABLE_PIMPL_DECLARATIONS(RequesterName);
};

/**
 * Toloka requester.
 */
class Requester
{
public:
    const std::string& id() const;
    const RequesterName& publicName() const;
    double balance() const;

    MOVABLE_PIMPL_DECLARATIONS(Requester)
};

} // namespace io
} // namespace toloka
} // namespace mrc
} // namespace maps
