#pragma once

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/common/include/pimpl_utils.h>
#include <maps/libs/json/include/value.h>
#include <yandex/maps/mrc/toloka_client/known_solution.h>

#include <boost/optional.hpp>

#include <string>
#include <iosfwd>

namespace maps {
namespace mrc {
namespace toloka {
namespace io {

class TaskCreationParams
{
public:
    TaskCreationParams(std::string poolId, json::Value inputValues);

    TaskCreationParams& setOverlap(size_t overlap);
    TaskCreationParams& setInfiniteOverlap();
    TaskCreationParams& setKnownSolutions(KnownSolutions knownSolutions);
    TaskCreationParams& setMessageOnUnknownSolution(std::string message);

    friend std::ostream& operator <<(std::ostream&, const TaskCreationParams&);

    friend std::ostream& operator <<(std::ostream&,
         const std::vector<TaskCreationParams>&);

    COPYABLE_PIMPL_DECLARATIONS(TaskCreationParams)
};

class Task
{
public:
    const std::string& id() const;
    const std::string& poolId() const;
    chrono::TimePoint createdAt() const;
    const json::Value& inputValues() const;
    boost::optional<size_t> overlap() const;
    bool hasInfiniteOverlap() const;
    const KnownSolutions& knownSolutions() const;
    const std::string& messageOnUnknownSolution() const;

    COPYABLE_PIMPL_DECLARATIONS(Task)
};


std::ostream& operator<<(std::ostream& os, const Task& task);

using Tasks = std::vector<Task>;

class TasksResponse
{
public:
    const Tasks& tasks() const;

    bool hasMore() const;

    MOVABLE_PIMPL_DECLARATIONS(TasksResponse)
};

/**
 * Tasks post response contains task suites data
 * for successfully created tasks and validation errors (translated
 * from http response) for those which failed.
 *
 * Keys in the maps indicate indices in the input array, as in documentation
 * https://tech.yandex.ru/toloka/doc/concepts/create-tasks-batch-docpage/
 * {
 * "items": {
 *   "0": {<task 0>},
 *   "2": {<task 2>}, ...
 *   "<n>": {<task n>}
 *    },
 * "validation_errors": {
 *   "1": {<validation errors for task 1>},
 *   "3": {<validation errors for task 3>}, ...
 *   "<m>": {<validation errors for task m>}
 *    }
 * }
 */
class TasksPostResponse
{
public:
    const std::unordered_map<size_t, Task> tasks() const;
    const std::unordered_map<size_t, json::Value> errors() const;

    MOVABLE_PIMPL_DECLARATIONS(TasksPostResponse)
};

} // namespace io
} // namespace toloka
} // namespace mrc
} // namespace maps

