#pragma once

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/common/include/pimpl_utils.h>
#include <maps/libs/json/include/value.h>
#include <yandex/maps/mrc/toloka_client/known_solution.h>

#include <map>
#include <string>
#include <vector>

namespace maps {
namespace mrc {
namespace toloka {
namespace io {

class TaskSuiteItem
{
public:
    TaskSuiteItem();

    static TaskSuiteItem fromJson(const json::Value& value);

    static TaskSuiteItem fromInputValues(json::Value /*move*/inputValues);

    const std::string& id() const;

    const json::Value& inputValues() const;

    const KnownSolutions& knownSolutions() const;

    const std::string& messageOnUnknownSolution() const;

    TaskSuiteItem& setId(std::string /*move*/id);

    TaskSuiteItem& setInputValues(json::Value /*move*/inputValues);

    TaskSuiteItem& setKnownSolutions(KnownSolutions /*move*/knownSolutions);

    TaskSuiteItem& setMessageOnUnknownSolution(std::string /*move*/message);

    COPYABLE_PIMPL_DECLARATIONS(TaskSuiteItem)
};

using TaskSuiteItems = std::vector<TaskSuiteItem>;


class TaskSuiteCreationParams
{
public:
    TaskSuiteCreationParams(std::string poolId, TaskSuiteItems items);

    TaskSuiteCreationParams& setOverlap(size_t overlap);

    friend std::ostream& operator <<(std::ostream&,
                                     const TaskSuiteCreationParams&);

    friend std::ostream& operator <<(std::ostream&,
        const std::vector<TaskSuiteCreationParams>&);

    COPYABLE_PIMPL_DECLARATIONS(TaskSuiteCreationParams)
};

class TaskSuite
{
public:
    TaskSuite(std::string poolId, TaskSuiteItems items);

    const std::string& id() const;

    const std::string& poolId() const;

    chrono::TimePoint createdAt() const;

    const TaskSuiteItems& tasks() const;

    size_t overlap() const;

    COPYABLE_PIMPL_DECLARATIONS(TaskSuite)
};

std::ostream& operator<<(std::ostream& os, const TaskSuite& taskSuite);

using TaskSuites = std::vector<TaskSuite>;

class TaskSuitesResponse
{
public:
    const TaskSuites& taskSuites() const;

    bool hasMore() const;

    MOVABLE_PIMPL_DECLARATIONS(TaskSuitesResponse)
};

/**
 * Task suites post response contains task suites data
 * for successfully created task suites and validation errors (translated
 * from http response) for those which failed.
 *
 * Keys in the maps indicate indices in the input array, as in documentation
 * https://tech.yandex.ru/toloka/api/doc/concepts/create-task-suite-batch-docpage/
 * {
 * "items": {
 *   "0": {<task suite 0>},
 *   "2": {<task suite 2>}, ...
 *   "<n>": {<task suite n>}
 *    },
 * "validation_errors": {
 *   "1": {<validation errors for task suite 1>},
 *   "3": {<validation errors for task suite 3>}, ...
 *   "<m>": {<validation errors for task suite m>}
 *    }
 * }
 */
class TaskSuitesPostResponse
{
public:
    const std::map<size_t, TaskSuite> taskSuites() const;
    const std::map<size_t, json::Value> errors() const;

    MOVABLE_PIMPL_DECLARATIONS(TaskSuitesPostResponse)
};


} // namespace io
} // namespace toloka
} // namespace mrc
} // namespace maps


