#include <yandex/maps/mrc/toloka_client/known_solution.h>
#include "known_solution_impl.h"
#include "magic_strings.h"

#include <maps/libs/json/include/value.h>

namespace maps {
namespace mrc {
namespace toloka {
namespace io {

KnownSolution::KnownSolution(json::Value outputValues, double correctnessWeight)
    : impl_(new Impl(std::move(outputValues), correctnessWeight))
{
}

COPYABLE_PIMPL_DEFINITIONS(KnownSolution)

const json::Value& KnownSolution::outputValues() const
{
    return impl_->outputValues_;
}

double KnownSolution::correctnessWeight() const
{
    return impl_->correctnessWeight_;
}

} // namespace io
} // namespace toloka
} // namespace mrc
} // namespace maps


