#pragma once

#include <yandex/maps/mrc/toloka_client/pool.h>

#include <maps/libs/json/include/value.h>

namespace maps {
namespace mrc {
namespace toloka {
namespace io {

using OptionalJsonValue = boost::optional<json::Value>;

class PoolCreationParams::Impl
{
public:
    Impl(const Pool& pool);

    std::string toJson() const;

    std::string privateName_;
    std::string projectId_;
    chrono::TimePoint expiresAt_;
    double rewardPerAssignment_;
    size_t assignmentMaxDurationSec_;
    size_t defaultOverlapTaskSuites_;
    bool hasAdultContent_;
    bool autoAcceptSolutions_;

    OptionalJsonValue filter_;
    OptionalJsonValue qualityControl_;
    OptionalJsonValue mixerConfig_;
};

class Pool::Impl {
public:
    // Parse Toloka server response
    explicit Impl(const json::Value& value);

    std::string toJson() const;

    std::string id_;
    std::string projectId_;
    std::string privateName_;
    PoolStatus status_;
    chrono::TimePoint createdAt_;
    chrono::TimePoint expiresAt_;
    boost::optional<chrono::TimePoint> lastStopped_;
    double rewardPerAssignment_;
    size_t assignmentMaxDurationSec_;
    size_t defaultOverlapTaskSuites_;
    bool hasAdultContent_;
    bool autoAcceptSolution_;
    boost::optional<PoolCloseReason> lastCloseReason_;

    OptionalJsonValue filter_;
    OptionalJsonValue qualityControl_;
    OptionalJsonValue mixerConfig_;
};


class PoolsResponse::Impl
{
public:
    Impl(Pools pools, bool hasMore)
        : pools_(std::move(pools)), hasMore_(hasMore)
    {
    }

    Pools pools_;
    bool hasMore_;
};

} // namespace io
} // namespace toloka
} // namespace mrc
} // namespace maps
