#include "requester_impl.h"
#include "magic_strings.h"

namespace maps {
namespace mrc {
namespace toloka {
namespace io {

RequesterName::Impl::Impl(const json::Value& value)
    : EN_(value[FIELD_EN_NAME].as<std::string>())
    , RU_(value[FIELD_RU_NAME].as<std::string>())
{

}

/**
 * https://yandex.ru/dev/toloka/doc/concepts/balance-docpage/
 */
Requester::Impl::Impl(const json::Value& value)
    : id_(value[FIELD_ID].as<std::string>())
    , publicName_(PImplFactory::create<RequesterName>(value[FIELD_PUBLIC_NAME]))
    , balance_(value[FIELD_BALANCE].as<double>())
{

}

} // namespace io
} // namespace toloka
} // namespace mrc
} // namespace maps
