#include <yandex/maps/mrc/toloka_client/task.h>
#include "task_impl.h"

#include <utility>

namespace maps {
namespace mrc {
namespace toloka {
namespace io {

COPYABLE_PIMPL_DEFINITIONS(TaskCreationParams)

TaskCreationParams::TaskCreationParams(
    std::string poolId,
    json::Value inputValues)
        : impl_(new Impl(std::move(poolId), std::move(inputValues)))
{
}

TaskCreationParams&
TaskCreationParams::setOverlap(size_t overlap)
{
    impl_->overlap_ = overlap;
    impl_->hasInfiniteOverlap_ = false;
    return *this;
}

TaskCreationParams&
TaskCreationParams::setInfiniteOverlap()
{
    impl_->overlap_ = boost::none;
    impl_->hasInfiniteOverlap_ = true;
    return *this;
}

TaskCreationParams&
TaskCreationParams::setKnownSolutions(KnownSolutions knownSolutions)
{
    impl_->knownSolutions_ = std::move(knownSolutions);
    return *this;
}

TaskCreationParams&
TaskCreationParams::setMessageOnUnknownSolution(std::string message)
{
    impl_->messageOnUnknownSolution_ = std::move(message);
    return *this;
}

COPYABLE_PIMPL_DEFINITIONS(Task)

const std::string& Task::id() const { return impl_->id_; }

const std::string& Task::poolId() const { return impl_->poolId_; }

chrono::TimePoint Task::createdAt() const { return impl_->createdAt_; }

const json::Value& Task::inputValues() const { return impl_->inputValues_; }

boost::optional<size_t> Task::overlap() const { return impl_->overlap_; }

bool Task::hasInfiniteOverlap() const { return impl_->hasInfiniteOverlap_; }

const KnownSolutions& Task::knownSolutions() const
{
    return impl_->knownSolutions_;
}

const std::string& Task::messageOnUnknownSolution() const
{
    return impl_->messageOnUnknownSolution_;
}


std::ostream& operator<<(std::ostream& os, const TaskCreationParams& params)
{
    return os << params.impl_->toJson();
}

std::ostream& operator<<(std::ostream& os,
                         const std::vector<TaskCreationParams>& paramsVec)
{
    json::Builder builder(os);
    builder << [&](json::ArrayBuilder b) {
        for (const auto& params : paramsVec) {
            b << [&](json::ObjectBuilder taskBuilder) {
                params.impl_->toJson(taskBuilder);
            };
        }
    };
    return os;
}


MOVABLE_PIMPL_DEFINITIONS(TasksResponse)

const Tasks& TasksResponse::tasks() const { return impl_->tasks_; }

bool TasksResponse::hasMore() const { return impl_->hasMore_; }


MOVABLE_PIMPL_DEFINITIONS(TasksPostResponse)

const std::unordered_map<size_t, Task> TasksPostResponse::tasks() const
{
    return impl_->tasks_;
}

const std::unordered_map<size_t, json::Value> TasksPostResponse::errors() const
{
    return impl_->errors_;
}

} // namespace io
} // namespace toloka
} // namespace mrc
} // namespace maps
