#pragma once

#include <yandex/maps/mrc/toloka_client/task.h>

namespace maps {
namespace mrc {
namespace toloka {
namespace io {

class TaskCreationParams::Impl
{
public:
    Impl(std::string poolId, json::Value inputValues)
        : poolId_(std::move(poolId))
        , inputValues_(std::move(inputValues))
    {
    }

    void toJson(json::ObjectBuilder builder) const;
    std::string toJson() const;

    std::string poolId_;
    json::Value inputValues_;
    boost::optional<size_t> overlap_ = 0;
    bool hasInfiniteOverlap_ = false;
    KnownSolutions knownSolutions_;
    std::string messageOnUnknownSolution_;
};

class Task::Impl
{
public:
    // Parse Toloka server response
    explicit Impl(const json::Value& value);

    std::string id_;
    std::string poolId_;
    chrono::TimePoint createdAt_;
    json::Value inputValues_;
    boost::optional<size_t> overlap_;
    bool hasInfiniteOverlap_;
    KnownSolutions knownSolutions_;
    std::string messageOnUnknownSolution_;
};

class TasksResponse::Impl
{
public:
    Impl(Tasks tasks, bool hasMore)
        : tasks_(std::move(tasks)), hasMore_(hasMore)
    {
    }

    Tasks tasks_;
    bool hasMore_;
};


class TasksPostResponse::Impl
{
public:
    Impl(std::unordered_map<size_t, Task> tasks,
         std::unordered_map<size_t, json::Value> errors)
            : tasks_(std::move(tasks))
            , errors_(std::move(errors))
    {}

    std::unordered_map<size_t, Task> tasks_;
    std::unordered_map<size_t, json::Value> errors_;
};

} // namespace io
} // namespace toloka
} // namespace mrc
} // namespace maps
