#pragma once

#include <yandex/maps/mrc/toloka_client/task_suite.h>

namespace maps {
namespace mrc {
namespace toloka {
namespace io {

class TaskSuiteItem::Impl
{
public:
    Impl()
        : inputValues_("")
    {
    }

    std::string id_;
    json::Value inputValues_;
    KnownSolutions knownSolutions_;
    std::string messageOnUnknownSolution_;
};

class TaskSuiteCreationParams::Impl
{
public:
    Impl(std::string poolId, TaskSuiteItems tasks)
        : poolId_(std::move(poolId))
        , tasks_(std::move(tasks))
    {
    }

    void toJson(json::ObjectBuilder builder) const;
    std::string toJson() const;

    std::string poolId_;
    TaskSuiteItems tasks_;
    size_t overlap_ = 0;
};


class TaskSuite::Impl
{
public:
    // Parse Toloka server response
    explicit Impl(const json::Value& value);

    std::string id_;
    std::string poolId_;
    chrono::TimePoint createdAt_;
    TaskSuiteItems tasks_;
    size_t overlap_ = 0;
};


class TaskSuitesResponse::Impl
{
public:
    Impl(TaskSuites taskSuites, bool hasMore)
        : taskSuites_(std::move(taskSuites)), hasMore_(hasMore)
    {
    }

    TaskSuites taskSuites_;
    bool hasMore_;
};


class TaskSuitesPostResponse::Impl
{
public:
    Impl(std::map<size_t, TaskSuite> taskSuites,
         std::map<size_t, json::Value> errors)
            : taskSuites_(std::move(taskSuites))
            , errors_(std::move(errors))
    {}

    std::map<size_t, TaskSuite> taskSuites_;
    std::map<size_t, json::Value> errors_;
};

} // namespace io
} // namespace toloka
} // namespace mrc
} // namespace maps
