#include <maps/wikimap/mapspro/services/mrc/libs/toloka_client/assignment_impl.h>
#include <maps/wikimap/mapspro/services/mrc/libs/toloka_client/tests/fixture.h>
#include <yandex/maps/mrc/toloka_client/assignment.h>
#include <yandex/maps/mrc/toloka_client/client.h>

namespace maps {
namespace mrc {
namespace toloka {
namespace io {
namespace test {

TEST_F(TolokaClientFixture, test_get_assignments)
{
    Filter filter;
    filter.byPoolId("pool-1");
    filter.createdAfter(maps::chrono::TimePoint());
    filter.submittedAfter(maps::chrono::TimePoint());

    auto response = client().getAssignments(filter);
    const auto& assignments = response.assignments();

    EXPECT_EQ(assignments.size(), 2u);

    // Check task suite 1 properties
    const auto& asgmt0 = assignments[0];
    EXPECT_EQ(asgmt0.id(), "1");
    EXPECT_EQ(asgmt0.poolId(), "pool-1");
    EXPECT_EQ(asgmt0.taskSuiteId(), "task-suite-1");
    EXPECT_EQ(maps::chrono::formatIsoDateTime(asgmt0.createdAt()), "2015-12-15T14:52:00Z");
    EXPECT_TRUE(asgmt0.submittedAt());
    auto submittedAtStr = maps::chrono::formatIsoDateTime(*asgmt0.submittedAt());
    EXPECT_EQ(submittedAtStr, "2015-12-15T15:10:00Z");
    EXPECT_EQ(asgmt0.tasks().size(), 1u);
    EXPECT_EQ(asgmt0.tasks()[0].id(), "task-1-1");
    EXPECT_TRUE(asgmt0.tasks()[0].inputValues().isObject());
    EXPECT_EQ(asgmt0.solutions().size(), 1u);
    EXPECT_TRUE(asgmt0.solutions()[0].outputValues().isObject());

    // Check task suite 2 properties
    const auto& asgmt1 = assignments[1];
    EXPECT_EQ(asgmt1.id(), "2");
    EXPECT_EQ(asgmt1.poolId(), "pool-1");
    EXPECT_EQ(asgmt1.taskSuiteId(), "task-suite-2");
    EXPECT_EQ(maps::chrono::formatIsoDateTime(asgmt1.createdAt()), "2015-12-15T16:00:00Z");
    EXPECT_TRUE(asgmt1.submittedAt());
    submittedAtStr = maps::chrono::formatIsoDateTime(*asgmt1.submittedAt());
    EXPECT_EQ(submittedAtStr, "2015-12-15T17:00:00Z");
    EXPECT_EQ(asgmt1.tasks().size(), 2u);
    EXPECT_EQ(asgmt1.tasks()[0].id(), "task-2-1");
    EXPECT_EQ(asgmt1.tasks()[1].id(), "task-2-2");
    EXPECT_TRUE(asgmt1.tasks()[0].inputValues().isObject());
    EXPECT_TRUE(asgmt1.tasks()[1].inputValues().isObject());
    EXPECT_EQ(asgmt1.solutions().size(), 2u);
    EXPECT_TRUE(asgmt1.solutions()[0].outputValues().isObject());
    EXPECT_TRUE(asgmt1.solutions()[1].outputValues().isObject());
}


TEST_F(TolokaClientFixture, test_set_assignment_status)
{
    client().acceptAssignment("assignment-1");
    client().acceptAssignment("assignment-2", "Good job!");
    client().rejectAssignment("assignment-3", "Bad job!");
}

} // test
} // namespace io
} // namespace toloka
} // namespace mrc
} // namespace maps
