#pragma once

#include <library/cpp/testing/gtest/gtest.h>
#include <yandex/maps/mrc/toloka_client/client.h>
#include <yandex/maps/mrc/unittest/local_server.h>

#ifndef YANDEX_MAPS_BUILD
#include <library/cpp/testing/common/env.h>
#include <maps/libs/process/include/process.h>

#include <chrono>

#endif

namespace maps {
namespace mrc {
namespace toloka {
namespace io {
namespace test {

inline const char* TOLOKA_TEST_SERVER_HOST = "127.0.0.1";
inline const char* SERVER_BINARY_PATH
    = "maps/wikimap/mapspro/services/mrc/libs/toloka_client/tools/test_toloka_server/test_toloka_server";

#ifndef YANDEX_MAPS_BUILD
namespace {

inline const unittest::TestServer g_tolokaTestServer(
    [](uint16_t port) {
        return process::Command(
                   {BinaryPath(SERVER_BINARY_PATH),
                   TOLOKA_TEST_SERVER_HOST,
                   std::to_string(port)});
    });

} // namespace
#endif

class TolokaClientFixture : public testing::Test {
public:
    TolokaClientFixture()
        : host_(TOLOKA_TEST_SERVER_HOST)
#ifdef YANDEX_MAPS_BUILD
        , port_(std::getenv("TOLOKA_STUB_PORT"))
#else
        , port_(g_tolokaTestServer.getPortStr())
#endif
        , authHeader_("Basic nevermind")
        , client_(host_ + ":" + port_, authHeader_)
    {
        client_.setSchema("http://")
            .setMaxRequestAttempts(5)
            .setTimeout(std::chrono::seconds(1))
            .setRetryInitialTimeout(std::chrono::milliseconds(10))
            .setRetryTimeoutBackoff(1);
    }

    TolokaClient& client() { return client_; }

private:
    std::string host_;
    std::string port_;
    std::string authHeader_;
    TolokaClient client_;
};

} // test
} // namespace io
} // namespace toloka
} // namespace mrc
} // namespace maps
