#!/bin/bash

PORT=`(netstat -an | grep tcp | awk '{ print $4; }' | sed 's/.*://; p'; seq 26000 27000) | sort -n | uniq -u | head -1`

# Start fake Toloka server
gunicorn --pythonpath ./tests/ --timeout 1 --bind 127.0.0.1:$PORT test_toloka_server:app &
trap "kill $!" EXIT
sleep 1

# Run tests
export TOLOKA_STUB_PORT=$PORT
tests/pool-tests && tests/task-tests && tests/task-suite-tests && tests/assignment-tests && tests/requester-tests
