#include <maps/wikimap/mapspro/services/mrc/libs/toloka_client/task_suite_impl.h>
#include <maps/wikimap/mapspro/services/mrc/libs/toloka_client/tests/fixture.h>
#include <yandex/maps/mrc/toloka_client/client.h>
#include <yandex/maps/mrc/toloka_client/task_suite.h>

namespace maps {
namespace mrc {
namespace toloka {
namespace io {
namespace test {

TEST_F(TolokaClientFixture, test_get_task_suites)
{
    Filter filter;
    filter.byPoolId("pool-123");

    auto response = client().getTaskSuites(filter);
    const auto& taskSuites = response.taskSuites();

    EXPECT_EQ(taskSuites.size(), 2u);

    // Check task suite 1 properties
    const auto& ts0 = taskSuites[0];
    EXPECT_EQ(ts0.id(), "1");
    EXPECT_EQ(ts0.poolId(), "1");
    EXPECT_EQ(maps::chrono::formatIsoDateTime(ts0.createdAt()), "2016-09-07T09:20:10Z");
    EXPECT_EQ(ts0.overlap(), 3u);
    EXPECT_EQ(ts0.tasks().size(), 2u);
    EXPECT_EQ(ts0.tasks()[0].id(), "task-1-1");
    EXPECT_TRUE(ts0.tasks()[0].inputValues().isObject());
    EXPECT_EQ(ts0.tasks()[0].knownSolutions().size(), 2u);
    EXPECT_FALSE(ts0.tasks()[0].messageOnUnknownSolution().empty());
    EXPECT_EQ(ts0.tasks()[1].id(), "task-1-2");
    EXPECT_TRUE(ts0.tasks()[1].inputValues().isObject());
    EXPECT_EQ(ts0.tasks()[1].knownSolutions().size(), 1u);
    EXPECT_TRUE(ts0.tasks()[1].messageOnUnknownSolution().empty());


    // Check task suite 2 properties
    const auto& ts1 = taskSuites[1];
    EXPECT_EQ(ts1.id(), "2");
    EXPECT_EQ(ts1.poolId(), "1");
    EXPECT_EQ(maps::chrono::formatIsoDateTime(ts1.createdAt()), "2016-12-07T09:00:00Z");
    EXPECT_EQ(ts1.overlap(), 5u);
    EXPECT_EQ(ts1.tasks().size(), 1u);
    EXPECT_EQ(ts1.tasks()[0].id(), "task-2-1");
    EXPECT_TRUE(ts1.tasks()[0].inputValues().isObject());
    EXPECT_TRUE(ts1.tasks()[0].knownSolutions().empty());
}

TEST_F(TolokaClientFixture, test_post_task_suite)
{
    TaskSuiteItems items {
        TaskSuiteItem::fromInputValues(json::Value::fromString("{\"month\": 3}")),
        TaskSuiteItem::fromInputValues(json::Value::fromString("{\"month\": 8}")),
        TaskSuiteItem::fromInputValues(json::Value::fromString("{\"month\": 12}"))
    };

    TaskSuiteCreationParams taskSuiteCreationParams("pool-123", items);

    auto taskSuite = client().postTaskSuite(taskSuiteCreationParams);
    EXPECT_EQ(taskSuite.id(), "task-suite-123");
    EXPECT_EQ(taskSuite.poolId(), "pool-123");
    EXPECT_GE(taskSuite.createdAt(), chrono::TimePoint());

    const auto& createdItems = taskSuite.tasks();
    EXPECT_EQ(createdItems.size(), 3u);
}

TEST_F(TolokaClientFixture, test_post_multiple_task_suites)
{
    std::vector<TaskSuiteCreationParams> paramsVec;

    TaskSuiteItems items1 {
        TaskSuiteItem::fromInputValues(json::Value::fromString("{\"month\": 2}")),
        TaskSuiteItem::fromInputValues(json::Value::fromString("{\"month\": 7}")),
        TaskSuiteItem::fromInputValues(json::Value::fromString("{\"month\": 11}"))
    };

    paramsVec.emplace_back("pool-123", items1);

    TaskSuiteItems items2 {
        TaskSuiteItem::fromInputValues(json::Value::fromString("{\"month\": 3}")),
        TaskSuiteItem::fromInputValues(json::Value::fromString("{\"month\": 8}")),
    };
    paramsVec.emplace_back("pool-456", items2);

    auto taskSuitesPostResp = client().postTaskSuites(paramsVec);
    EXPECT_TRUE(taskSuitesPostResp.errors().empty());
    const auto& taskSuites = taskSuitesPostResp.taskSuites();

    EXPECT_EQ(taskSuites.size(), 2u);

    EXPECT_EQ(taskSuites.at(0).id(), "task-suite-0");
    EXPECT_EQ(taskSuites.at(0).poolId(), "pool-123");
    EXPECT_GE(taskSuites.at(0).createdAt(), chrono::TimePoint());
    EXPECT_EQ(taskSuites.at(0).tasks().size(), 3u);

    EXPECT_EQ(taskSuites.at(1).id(), "task-suite-1");
    EXPECT_EQ(taskSuites.at(1).poolId(), "pool-456");
    EXPECT_GE(taskSuites.at(1).createdAt(), chrono::TimePoint());
    EXPECT_EQ(taskSuites.at(1).tasks().size(), 2u);
}

TEST_F(TolokaClientFixture, test_set_task_suite_overlap)
{
    client().setTaskSuiteOverlap("task-suite-123", 10);
}

} // test
} // namespace io
} // namespace toloka
} // namespace mrc
} // namespace maps
