#pragma once

#include <maps/libs/geolib/include/bounding_box.h>
#include <yandex/maps/wiki/common/string_utils.h>

#include <cstdint>
#include <string>
#include <unordered_map>
#include <vector>

namespace maps::mrc::toloka::common {

using Rect = geolib3::BoundingBox;

struct TolokaAnswer {
    std::string assignment;
    std::string photo; // URL
    std::vector<Rect> rects;
};

/// @see https://en.wikipedia.org/wiki/Precision_and_recall
struct PrecisionAndRecall {
    size_t selected = 0;
    size_t relevant = 0;
    size_t truePositive = 0;
};

using PhotoToRectsMap = std::unordered_map<std::string, std::vector<Rect>>;

/// Merge Toloka results for a single photo received from multiple users
std::vector<Rect> aggregatePhoto(const std::vector<TolokaAnswer>&);

/// Merge Toloka answers for every photo
PhotoToRectsMap aggregatePhotos(std::vector<TolokaAnswer>&);

using AssignmentToPrecisionAndRecallMap
    = std::unordered_map<std::string, PrecisionAndRecall>;

/// Merge user assignments to approve/reject
AssignmentToPrecisionAndRecallMap aggregateAssignments(
    std::vector<TolokaAnswer>&, const PhotoToRectsMap& aggregatedPhotos);

/// Helpers
inline Rect rect(double x1, double y1, double x2, double y2)
{
    return {geolib3::Point2(x1, y1), geolib3::Point2(x2, y2)};
}

std::pair<float, float> toPair(const PrecisionAndRecall&);

} // namespace maps::mrc::toloka::common
