#include <maps/wikimap/mapspro/services/mrc/libs/toloka_manager/include/detection_pair_match.h>
#include <maps/libs/json/include/builder.h>
#include <maps/libs/json/include/std.h>
#include <maps/libs/json/include/value.h>

namespace maps::mrc::toloka {

constexpr maps::enum_io::Representations<DetectionPairMatchResult>
DETECTION_PAIR_MATCH_RESULT_TO_STRING{
    {DetectionPairMatchResult::Yes, "yes"},
    {DetectionPairMatchResult::No, "no"},
    {DetectionPairMatchResult::Unknown, "unknown"},
    {DetectionPairMatchResult::NotLoaded, "not-loaded"},
};

DEFINE_ENUM_IO(DetectionPairMatchResult, DETECTION_PAIR_MATCH_RESULT_TO_STRING);

void DetectionPairMatchInput::json(json::ObjectBuilder builder) const
{
    builder[FIELD_IMAGE_1] = imageUrl1_;
    builder[FIELD_BBOX_1] = bbox1_;

    builder[FIELD_IMAGE_2] = imageUrl2_;
    builder[FIELD_BBOX_2] = bbox2_;
}

template <>
DetectionPairMatchInput parseJson(const json::Value& jsonInput)
{
    return DetectionPairMatchInput(
        jsonInput[FIELD_IMAGE_1].as<std::string>(),
        common::ImageBox::fromJson(jsonInput[FIELD_BBOX_1]),
        jsonInput[FIELD_IMAGE_2].as<std::string>(),
        common::ImageBox::fromJson(jsonInput[FIELD_BBOX_2])
    );
}

void DetectionPairMatchOutput::json(json::ObjectBuilder builder) const
{
    builder[FIELD_RESULT] = toString(result_);
}

template <>
DetectionPairMatchOutput parseJson(const json::Value& jsonOutput)
{
    DetectionPairMatchResult result;
    fromString(jsonOutput[FIELD_RESULT].as<std::string>(), result);

    return DetectionPairMatchOutput(result);
}

DetectionPairMatchInput::DetectionPairMatchInput(
    std::string imageUrl1, common::ImageBox bbox1,
    std::string imageUrl2, common::ImageBox bbox2)
    : imageUrl1_(std::move(imageUrl1)), bbox1_(std::move(bbox1))
    , imageUrl2_(std::move(imageUrl2)), bbox2_(std::move(bbox2))
{
}

const std::string& DetectionPairMatchInput::imageUrl1() const { return imageUrl1_; }

const common::ImageBox& DetectionPairMatchInput::bbox1() const { return bbox1_; }

const std::string& DetectionPairMatchInput::imageUrl2() const { return imageUrl2_; }

const common::ImageBox& DetectionPairMatchInput::bbox2() const { return bbox2_; }


DetectionPairMatchOutput::DetectionPairMatchOutput(
    DetectionPairMatchResult result)
    : result_(result)
{
}

DetectionPairMatchResult DetectionPairMatchOutput::result() const { return result_; }

bool operator==(const DetectionPairMatchOutput& lhs, const DetectionPairMatchOutput& rhs)
{
    return lhs.introspect() == rhs.introspect();
}

bool operator<(const DetectionPairMatchOutput& lhs, const DetectionPairMatchOutput& rhs)
{
    return lhs.introspect() < rhs.introspect();
}

std::ostream& operator<<(std::ostream& out, const DetectionPairMatchOutput& taskOutput)
{
    json::Builder builder(out);
    builder << [&](json::ObjectBuilder b) {
        taskOutput.json(b);
    };
    return out;
}

} // namespace maps::mrc::toloka
