#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/toloka_manager/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/toloka_manager/include/task.h>

#include <maps/libs/enum_io/include/enum_io_fwd.h>

#include <string>
#include <vector>

namespace maps {
namespace mrc {
namespace toloka {

class ApprovementInput {
public:
    ApprovementInput(std::string imageUrl, std::vector<common::ImageBox>);

    const std::string& imageUrl() const;
    const std::vector<common::ImageBox>& bboxes() const;

    ApprovementInput& setImageUrl(std::string url);

    void json(json::ObjectBuilder) const;

private:
    std::string imageUrl_;
    std::vector<common::ImageBox> bboxes_;
};

using ApprovementInputs = std::vector<ApprovementInput>;

enum class ApprovementAnswer { Yes, No, NotLoaded };

DECLARE_ENUM_IO(ApprovementAnswer)

class ApprovementOutput {
public:
    ApprovementOutput(ApprovementAnswer answer);

    ApprovementAnswer answer() const;

    void json(json::ObjectBuilder) const;

    auto introspect() const {
        return answer_;
    }

private:
    ApprovementAnswer answer_;
};

/// Returns true if 'answer's in both objects are equal,
///         false otherwise
bool operator==(const ApprovementOutput& lhs, const ApprovementOutput& rhs);

/// Uses ordering by 'answer'
bool operator<(const ApprovementOutput& lhs, const ApprovementOutput& rhs);

std::ostream& operator<<(std::ostream& out, const ApprovementOutput& taskOutput);

/**
 * Task traits for any kind of confirmations
 */
struct ApprovementTaskTraits {
    using InputType = ApprovementInput;
    using OutputType = ApprovementOutput;
    static constexpr auto DB_TASK_TYPE = DbTaskType::Approvement;
};

using ApprovementTask = Task<ApprovementTaskTraits>;
using ApprovementTasks = std::vector<ApprovementTask>;

} // namespace toloka
} // namespace mrc
} // namespace maps
