#pragma once

#include <string>

#include <maps/libs/chrono/include/time_point.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/toloka/task.h>

namespace maps {
namespace mrc {
namespace toloka {

using TaskId = db::TId;
using TimePoint = chrono::TimePoint;

using TaskStatus = db::toloka::TaskStatus;
using DbTaskType = db::toloka::TaskType;
using DbPlatform = db::toloka::Platform;

template <typename T>
using InputType = typename T::InputType;
template <typename T>
using OutputType = typename T::OutputType;

const std::string FIELD_BBOX = "bbox";
const std::string FIELD_BBOXES = "bboxes";
const std::string FIELD_IMAGE = "image";
const std::string FIELD_POLYGONS = "polygons";
const std::string FIELD_PROBLEM = "problem";
const std::string FIELD_RESULT = "result";
const std::string FIELD_SIGN_ID = "sign_id";
const std::string FIELD_SOURCE = "source";
const std::string FIELD_STATE = "state";
const std::string FIELD_HOUSE_NUMBER = "house_number";
const std::string FIELD_POLYGON_TYPE = "type";
const std::string FIELD_DATA = "data";
const std::string FIELD_P1 = "p1";
const std::string FIELD_P2 = "p2";
const std::string FIELD_X = "x";
const std::string FIELD_Y = "y";
const std::string FIELD_GOLDEN_POLYGONS = "golden_polygons";
const std::string FIELD_IS_CORRECT = "is_correct";
const std::string FIELD_IMAGE_1 = "image1";
const std::string FIELD_IMAGE_2 = "image2";
const std::string FIELD_BBOX_1 = "bbox1";
const std::string FIELD_BBOX_2 = "bbox2";
const std::string FIELD_IS_VISIBLE = "is_visible";
const std::string FIELD_MISSING_REASON = "missing_reason";

const std::string POLYGON_TYPE_RECTANGLE = "rectangle";

} // namespace toloka
} // namespace mrc
} // namespace maps
