#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/toloka_manager/include/task.h>

#include <maps/libs/enum_io/include/enum_io.h>

#include <string>
#include <vector>
#include <optional>

namespace maps::mrc::toloka {

class DetectionMissingOnFrameInput {
public:
    DetectionMissingOnFrameInput(
        std::string imageUrl1, common::ImageBox bbox1,
        std::string imageUrl2);

    const std::string& imageUrl1() const;
    const common::ImageBox& bbox1() const;

    const std::string& imageUrl2() const;

    void json(json::ObjectBuilder) const;

private:
    std::string imageUrl1_;
    common::ImageBox bbox1_;

    std::string imageUrl2_;
};

using DetectionMissingOnFrameInputs = std::vector<DetectionMissingOnFrameInput>;


enum class DetectionMissingOnFrameIsVisible {
    Yes,
    No,
    NotLoaded,
    Unknown,
};

DECLARE_ENUM_IO(DetectionMissingOnFrameIsVisible);

enum class DetectionMissingOnFrameMissingReason {
    Missing,
    Hidden,
    PlaceIsNotVisible,
    Unknown,
};

DECLARE_ENUM_IO(DetectionMissingOnFrameMissingReason);

class DetectionMissingOnFrameOutput {
public:
    DetectionMissingOnFrameOutput(
        DetectionMissingOnFrameIsVisible isVisible,
        std::optional<DetectionMissingOnFrameMissingReason> missingReason);

    const DetectionMissingOnFrameIsVisible& isVisible() const;
    const std::optional<DetectionMissingOnFrameMissingReason>& missingReason() const;

    void json(json::ObjectBuilder) const;

    auto introspect() const {
        return std::tie(isVisible_, missingReason_);
    }

private:
    DetectionMissingOnFrameIsVisible isVisible_;
    std::optional<DetectionMissingOnFrameMissingReason> missingReason_;
};


bool operator==(const DetectionMissingOnFrameOutput& lhs, const DetectionMissingOnFrameOutput& rhs);

bool operator<(const DetectionMissingOnFrameOutput& lhs, const DetectionMissingOnFrameOutput& rhs);

std::ostream& operator<<(std::ostream& out, const DetectionMissingOnFrameOutput& taskOutput);


struct DetectionMissingOnFrameTaskTraits {
    using InputType = DetectionMissingOnFrameInput;
    using OutputType = DetectionMissingOnFrameOutput;
    static constexpr auto DB_TASK_TYPE = DbTaskType::DetectionMissingOnFrame;
};

using DetectionMissingOnFrameTask = Task<DetectionMissingOnFrameTaskTraits>;
using DetectionMissingOnFrameTasks = std::vector<DetectionMissingOnFrameTask>;

} // namespace maps::mrc::toloka
