#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/toloka_manager/include/task.h>

#include <maps/libs/enum_io/include/enum_io.h>

#include <string>
#include <vector>
#include <optional>

namespace maps::mrc::toloka {

class DetectionPairMatchInput {
public:
    DetectionPairMatchInput(
        std::string imageUrl1, common::ImageBox bbox1,
        std::string imageUrl2, common::ImageBox bbox2);

    const std::string& imageUrl1() const;
    const common::ImageBox& bbox1() const;

    const std::string& imageUrl2() const;
    const common::ImageBox& bbox2() const;

    void json(json::ObjectBuilder) const;

private:
    std::string imageUrl1_;
    common::ImageBox bbox1_;

    std::string imageUrl2_;
    common::ImageBox bbox2_;
};

using DetectionPairMatchInputs = std::vector<DetectionPairMatchInput>;


enum class DetectionPairMatchResult {
    Yes,
    No,
    Unknown,
    NotLoaded
};

DECLARE_ENUM_IO(DetectionPairMatchResult);


class DetectionPairMatchOutput {
public:
    DetectionPairMatchOutput(DetectionPairMatchResult result);

    DetectionPairMatchResult result() const;

    void json(json::ObjectBuilder) const;

    auto introspect() const {
        return std::tie(result_);
    }

private:
    DetectionPairMatchResult result_;
};


bool operator==(const DetectionPairMatchOutput& lhs, const DetectionPairMatchOutput& rhs);

bool operator<(const DetectionPairMatchOutput& lhs, const DetectionPairMatchOutput& rhs);

std::ostream& operator<<(std::ostream& out, const DetectionPairMatchOutput& taskOutput);


struct DetectionPairMatchTaskTraits {
    using InputType = DetectionPairMatchInput;
    using OutputType = DetectionPairMatchOutput;
    static constexpr auto DB_TASK_TYPE = DbTaskType::DetectionPairMatch;
};

using DetectionPairMatchTask = Task<DetectionPairMatchTaskTraits>;
using DetectionPairMatchTasks = std::vector<DetectionPairMatchTask>;

} // namespace maps::mrc::toloka
